  {
This program produce radial distribution of the ED image
from Ratio images 

created 3/23/2009 by A.Gahlmann Ver. 01.
}

const
  	 			Prompt = 'Select an image for calculation' ;
		 	
		  	  	PathR = 'D:\UED4_Data_processed\Utilities_UED4\XYarrayNEW\';
	
	 	 
//------------> Global variables
var

    xSize, ySize; 		  	 	  		 	//image size	 
 	X0,Y0;
	IMG;
	Start;
	RR, F;											

	
{
 ************************************************************************
 ***                                                                  ***
 ***	                      Procedure RAD							  ***
 ***																  ***
 ************************************************************************ 
This procedure generates a polar coordinate image with center passed as input parameters 
 }  

procedure RAD(X_off,Y_off);

var
  Image_R;                                      {Polar-field image (equal radius field)}
  i, j;											{indices}
  Full;
begin
   Full:='x'+Str(Word(Round(10*X_off)))+'y'+Str(Word(Round(10*Y_off)));	  		//Rounds the center coordinates, converts the expression to word and then to a string
   if FileExists(PathR+Full+'.tif') then										//Check if a polar image already exists
   begin
      WriteStatus('File Already Exists  '+ Full);								//Report that the file exists 
   end   
   else   
   begin
      WriteStatus('X_off= '+Str(X_off)+ '  Y_off= '+Str(Y_off));				//display the center coordinates 
      Image_R:= CreateImage(Double, xSize, ySize);								//create a radial image of type double
      for i:= 0 to (xSize-1) do	
         for j:= 0 to (ySize-1) do
            Image_R[i,j] := Sqrt(Sqr(i-X_off)+Sqr(j-Y_off));					//adding the value of radial distance to each pixel in the image
      Save(Image_R,PathR+Full+'.tif');											//save the radial image in the output directory 
      Free(Image_R);															//free the memory held by the variable 
   end;
end;  
  
{---------> end of procedure RAD}
	
	
	
	
{
*************************************************************************************************
********************** procedure RadialNormalize                       **************************
*************************************************************************************************
{This program produce 1D radial distribution from ED image with rejection of bad points}

procedure RadialNormalize(Img, R_Field);			        //Radial(curIm, curMask, F, 'F', cur});

var


   F_Image;                  					//Equal radii Mask images}
   Masked_FF;									//Masked ED Image and standard deviation image
   F_pix_initial;                   		    //number of pixels at certain radius
   Rad_F;										//Output Sum of all pixels with equal radius
   Mean;
   Coeff;										//Normalization Coefficient
   Image_Rad_Norm;			 					//Radially Normalized Image
   i;
      
   
  begin
  
			Image_Rad_Norm:=Img*0;
						
          for i:=0  to Integer((xSize)/2-1-Start) do							//step through the radii
           begin
		   
			   F_Image := ( R_field > Start+i)  and (R_field <= Start+i+1);  //binary ring mask of current radius
		 	   F_pix_initial:= Longint(SumOf(F_Image)); 	   	   			 //get the initial number of pixels in the ring mask image

               Masked_FF:=Single(Img*F_Image);				    //mask the input diffraction image
   			   Rad_F:=Single(SumOf(Masked_FF));						//sum intensity count for current radius
			   Mean:=Rad_F/F_pix_initial;							//mean count for current radius
			   Coeff:=1/Mean;										//Calculate the ith normalization coefficient
		 	   Masked_FF:=Masked_FF*Coeff;							//Normalize the radial image
			   Image_Rad_Norm:=Image_Rad_Norm+Masked_FF;			//add the current radius to the final image
			   
		   end;
		
		Show(Image_Rad_Norm, 'Image_Rad_Norm');
						
end;
//---------------> End of procedure Radial <------------------------------

{
 ************************************************************************
 ************************************************************************
 ***                                                                  ***
 ***	                      Main program							  ***
 ***																  ***
 ************************************************************************ 
 ************************************************************************
}

begin

 	 		 if GetNumImages = 0 then halt( 'This program requires a desktop image' ) ;	 		  //Return the number of images on the desktop
             	      SelectImage(Prompt, Img ) ;			 	   	 		 		  	  //Select an image from a list of desktop images
             if IsNull( Img ) then halt( 'No image was selected' ) ;	 				  //Return true if the variable Img is uninitialized

			xSize:=GetXSize(Img);						  	 							  //Return the x-dimension of the size definition image
            ySize:=GetYSize(Img);														  //Return the y-dimension of the size definition image
				
			X0:=676;
			Y0:=630;
			Start:=0;
			GetNumber('Enter the X0 coordinate',X0);  						//Display a dialog box and prompt the user to enter a number for the x center coordinate
			GetNumber('Enter the Y0 coordinate',Y0);						//Display a dialog box and prompt the user to enter a number for the x center coordinate




//-----> polar image selection						  
		     RR:='X'+Str(Word(Round(10*X0)))+'y'+Str(Word(Round(10*Y0)));		//polar image file name				  
 		     Open(PathR + RR+'.tif',F);										//open the polar image, if it exists					  
	             if IsNull( F ) then          				  //Return true if the variable Img is uninitialized
		 		     RAD(X0,Y0);				  			 			//This procedure generates a polar coordinate image with center passed as input parameters

			 Open(PathR + RR+'.tif',F);										//open the polar image					  

			 WriteStatus('Selected polar image is ' + RR);						//Write Status 

			 
			 RadialNormalize(Img, F);			  	  							//This program produces 1D radial distribution from ED image with rejection of bad points			


			 PlaySound( 'C:\Program Files\Digital Optics\V++\autorun.wav' ) ;				
			 WriteInfo('Calculation completed!');


end
